package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetSitesResponse(
    sites: Option[Iterable[zio.aws.networkmanager.model.Site]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetSitesResponse = {
    import GetSitesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
      .builder()
      .optionallyWith(
        sites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.sites)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetSitesResponse.ReadOnly =
    zio.aws.networkmanager.model.GetSitesResponse.wrap(buildAwsValue())
}
object GetSitesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetSitesResponse =
      zio.aws.networkmanager.model.GetSitesResponse(
        sites.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def sites: Option[List[zio.aws.networkmanager.model.Site.ReadOnly]]
    def nextToken: Option[NextToken]
    def getSites
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Site.ReadOnly]] =
      AwsError.unwrapOptionField("sites", sites)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
  ) extends zio.aws.networkmanager.model.GetSitesResponse.ReadOnly {
    override val sites
        : Option[List[zio.aws.networkmanager.model.Site.ReadOnly]] = scala
      .Option(impl.sites())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.Site.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetSitesResponse
  ): zio.aws.networkmanager.model.GetSitesResponse.ReadOnly = new Wrapper(impl)
}
