package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ConnectPeerId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetConnectPeerRequest(connectPeerId: ConnectPeerId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest = {
    import GetConnectPeerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest
      .builder()
      .connectPeerId(ConnectPeerId.unwrap(connectPeerId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetConnectPeerRequest.ReadOnly =
    zio.aws.networkmanager.model.GetConnectPeerRequest.wrap(buildAwsValue())
}
object GetConnectPeerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetConnectPeerRequest =
      zio.aws.networkmanager.model.GetConnectPeerRequest(connectPeerId)
    def connectPeerId: ConnectPeerId
    def getConnectPeerId: ZIO[Any, Nothing, ConnectPeerId] =
      ZIO.succeed(connectPeerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest
  ) extends zio.aws.networkmanager.model.GetConnectPeerRequest.ReadOnly {
    override val connectPeerId: ConnectPeerId =
      zio.aws.networkmanager.model.primitives
        .ConnectPeerId(impl.connectPeerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerRequest
  ): zio.aws.networkmanager.model.GetConnectPeerRequest.ReadOnly = new Wrapper(
    impl
  )
}
