package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DisassociateConnectPeerResponse(
    connectPeerAssociation: Option[
      zio.aws.networkmanager.model.ConnectPeerAssociation
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerResponse = {
    import DisassociateConnectPeerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerResponse
      .builder()
      .optionallyWith(
        connectPeerAssociation.map(value => value.buildAwsValue())
      )(_.connectPeerAssociation)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly =
    zio.aws.networkmanager.model.DisassociateConnectPeerResponse
      .wrap(buildAwsValue())
}
object DisassociateConnectPeerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DisassociateConnectPeerResponse =
      zio.aws.networkmanager.model.DisassociateConnectPeerResponse(
        connectPeerAssociation.map(value => value.asEditable)
      )
    def connectPeerAssociation
        : Option[zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly]
    def getConnectPeerAssociation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly
    ] = AwsError.unwrapOptionField(
      "connectPeerAssociation",
      connectPeerAssociation
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerResponse
  ) extends zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly {
    override val connectPeerAssociation
        : Option[zio.aws.networkmanager.model.ConnectPeerAssociation.ReadOnly] =
      scala
        .Option(impl.connectPeerAssociation())
        .map(value =>
          zio.aws.networkmanager.model.ConnectPeerAssociation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DisassociateConnectPeerResponse
  ): zio.aws.networkmanager.model.DisassociateConnectPeerResponse.ReadOnly =
    new Wrapper(impl)
}
