package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ConnectAttachmentOptions(
    protocol: Option[zio.aws.networkmanager.model.TunnelProtocol] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ConnectAttachmentOptions = {
    import ConnectAttachmentOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ConnectAttachmentOptions
      .builder()
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly =
    zio.aws.networkmanager.model.ConnectAttachmentOptions.wrap(buildAwsValue())
}
object ConnectAttachmentOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ConnectAttachmentOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ConnectAttachmentOptions =
      zio.aws.networkmanager.model
        .ConnectAttachmentOptions(protocol.map(value => value))
    def protocol: Option[zio.aws.networkmanager.model.TunnelProtocol]
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.TunnelProtocol] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectAttachmentOptions
  ) extends zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly {
    override val protocol: Option[zio.aws.networkmanager.model.TunnelProtocol] =
      scala
        .Option(impl.protocol())
        .map(value => zio.aws.networkmanager.model.TunnelProtocol.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ConnectAttachmentOptions
  ): zio.aws.networkmanager.model.ConnectAttachmentOptions.ReadOnly =
    new Wrapper(impl)
}
