package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RejectAttachmentResponse(
    attachment: Option[zio.aws.networkmanager.model.Attachment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RejectAttachmentResponse = {
    import RejectAttachmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RejectAttachmentResponse
      .builder()
      .optionallyWith(attachment.map(value => value.buildAwsValue()))(
        _.attachment
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly =
    zio.aws.networkmanager.model.RejectAttachmentResponse.wrap(buildAwsValue())
}
object RejectAttachmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RejectAttachmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RejectAttachmentResponse =
      zio.aws.networkmanager.model
        .RejectAttachmentResponse(attachment.map(value => value.asEditable))
    def attachment: Option[zio.aws.networkmanager.model.Attachment.ReadOnly]
    def getAttachment
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Attachment.ReadOnly] =
      AwsError.unwrapOptionField("attachment", attachment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RejectAttachmentResponse
  ) extends zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly {
    override val attachment
        : Option[zio.aws.networkmanager.model.Attachment.ReadOnly] = scala
      .Option(impl.attachment())
      .map(value => zio.aws.networkmanager.model.Attachment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RejectAttachmentResponse
  ): zio.aws.networkmanager.model.RejectAttachmentResponse.ReadOnly =
    new Wrapper(impl)
}
