package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  GlobalNetworkId,
  DeviceId,
  SiteId,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDevicesRequest(
    globalNetworkId: GlobalNetworkId,
    deviceIds: Option[Iterable[DeviceId]] = None,
    siteId: Option[SiteId] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest = {
    import GetDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        deviceIds.map(value =>
          value.map { item =>
            DeviceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deviceIds)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetDevicesRequest.ReadOnly =
    zio.aws.networkmanager.model.GetDevicesRequest.wrap(buildAwsValue())
}
object GetDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetDevicesRequest =
      zio.aws.networkmanager.model.GetDevicesRequest(
        globalNetworkId,
        deviceIds.map(value => value),
        siteId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def deviceIds: Option[List[DeviceId]]
    def siteId: Option[SiteId]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDeviceIds: ZIO[Any, AwsError, List[DeviceId]] =
      AwsError.unwrapOptionField("deviceIds", deviceIds)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
  ) extends zio.aws.networkmanager.model.GetDevicesRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val deviceIds: Option[List[DeviceId]] = scala
      .Option(impl.deviceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.DeviceId(item)
        }.toList
      )
    override val siteId: Option[SiteId] = scala
      .Option(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
  ): zio.aws.networkmanager.model.GetDevicesRequest.ReadOnly = new Wrapper(impl)
}
