package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetCustomerGatewayAssociationsResponse(
    customerGatewayAssociations: Option[
      Iterable[zio.aws.networkmanager.model.CustomerGatewayAssociation]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse = {
    import GetCustomerGatewayAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse
      .builder()
      .optionallyWith(
        customerGatewayAssociations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customerGatewayAssociations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly =
    zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse
      .wrap(buildAwsValue())
}
object GetCustomerGatewayAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse =
      zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse(
        customerGatewayAssociations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def customerGatewayAssociations: Option[
      List[zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getCustomerGatewayAssociations: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "customerGatewayAssociations",
      customerGatewayAssociations
    )
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse
  ) extends zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly {
    override val customerGatewayAssociations: Option[
      List[zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly]
    ] = scala
      .Option(impl.customerGatewayAssociations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CustomerGatewayAssociation.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsResponse
  ): zio.aws.networkmanager.model.GetCustomerGatewayAssociationsResponse.ReadOnly =
    new Wrapper(impl)
}
