package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  GlobalNetworkId,
  DeviceId,
  ConnectionId,
  MaxResults
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetConnectionsRequest(
    globalNetworkId: GlobalNetworkId,
    connectionIds: Option[Iterable[ConnectionId]] = None,
    deviceId: Option[DeviceId] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest = {
    import GetConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        connectionIds.map(value =>
          value.map { item =>
            ConnectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectionIds)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetConnectionsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetConnectionsRequest.wrap(buildAwsValue())
}
object GetConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetConnectionsRequest =
      zio.aws.networkmanager.model.GetConnectionsRequest(
        globalNetworkId,
        connectionIds.map(value => value),
        deviceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def connectionIds: Option[List[ConnectionId]]
    def deviceId: Option[DeviceId]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getConnectionIds: ZIO[Any, AwsError, List[ConnectionId]] =
      AwsError.unwrapOptionField("connectionIds", connectionIds)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
  ) extends zio.aws.networkmanager.model.GetConnectionsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val connectionIds: Option[List[ConnectionId]] = scala
      .Option(impl.connectionIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.ConnectionId(item)
        }.toList
      )
    override val deviceId: Option[DeviceId] = scala
      .Option(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
  ): zio.aws.networkmanager.model.GetConnectionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
