package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{SiteId, GlobalNetworkId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteSiteRequest(
    globalNetworkId: GlobalNetworkId,
    siteId: SiteId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest = {
    import DeleteSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .siteId(SiteId.unwrap(siteId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeleteSiteRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteSiteRequest.wrap(buildAwsValue())
}
object DeleteSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteSiteRequest =
      zio.aws.networkmanager.model.DeleteSiteRequest(globalNetworkId, siteId)
    def globalNetworkId: GlobalNetworkId
    def siteId: SiteId
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getSiteId: ZIO[Any, Nothing, SiteId] = ZIO.succeed(siteId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest
  ) extends zio.aws.networkmanager.model.DeleteSiteRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val siteId: SiteId =
      zio.aws.networkmanager.model.primitives.SiteId(impl.siteId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteSiteRequest
  ): zio.aws.networkmanager.model.DeleteSiteRequest.ReadOnly = new Wrapper(impl)
}
