package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ClientToken,
  VpnConnectionArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateSiteToSiteVpnAttachmentRequest(
    coreNetworkId: CoreNetworkId,
    vpnConnectionArn: VpnConnectionArn,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None,
    clientToken: Option[ClientToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest = {
    import CreateSiteToSiteVpnAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest
      .builder()
      .coreNetworkId(CoreNetworkId.unwrap(coreNetworkId): java.lang.String)
      .vpnConnectionArn(
        VpnConnectionArn.unwrap(vpnConnectionArn): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest
      .wrap(buildAwsValue())
}
object CreateSiteToSiteVpnAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest =
      zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest(
        coreNetworkId,
        vpnConnectionArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def coreNetworkId: CoreNetworkId
    def vpnConnectionArn: VpnConnectionArn
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def clientToken: Option[ClientToken]
    def getCoreNetworkId: ZIO[Any, Nothing, CoreNetworkId] =
      ZIO.succeed(coreNetworkId)
    def getVpnConnectionArn: ZIO[Any, Nothing, VpnConnectionArn] =
      ZIO.succeed(vpnConnectionArn)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest
  ) extends zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest.ReadOnly {
    override val coreNetworkId: CoreNetworkId =
      zio.aws.networkmanager.model.primitives
        .CoreNetworkId(impl.coreNetworkId())
    override val vpnConnectionArn: VpnConnectionArn =
      zio.aws.networkmanager.model.primitives
        .VpnConnectionArn(impl.vpnConnectionArn())
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Option[ClientToken] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.networkmanager.model.primitives.ClientToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest
  ): zio.aws.networkmanager.model.CreateSiteToSiteVpnAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
