package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  LinkId,
  DeviceId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateConnectionRequest(
    globalNetworkId: GlobalNetworkId,
    deviceId: DeviceId,
    connectedDeviceId: DeviceId,
    linkId: Option[LinkId] = None,
    connectedLinkId: Option[LinkId] = None,
    description: Option[ConstrainedString] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest = {
    import CreateConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .connectedDeviceId(DeviceId.unwrap(connectedDeviceId): java.lang.String)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(
        connectedLinkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.connectedLinkId)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateConnectionRequest.ReadOnly =
    zio.aws.networkmanager.model.CreateConnectionRequest.wrap(buildAwsValue())
}
object CreateConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CreateConnectionRequest =
      zio.aws.networkmanager.model.CreateConnectionRequest(
        globalNetworkId,
        deviceId,
        connectedDeviceId,
        linkId.map(value => value),
        connectedLinkId.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: GlobalNetworkId
    def deviceId: DeviceId
    def connectedDeviceId: DeviceId
    def linkId: Option[LinkId]
    def connectedLinkId: Option[LinkId]
    def description: Option[ConstrainedString]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
    def getConnectedDeviceId: ZIO[Any, Nothing, DeviceId] =
      ZIO.succeed(connectedDeviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getConnectedLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("connectedLinkId", connectedLinkId)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest
  ) extends zio.aws.networkmanager.model.CreateConnectionRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val deviceId: DeviceId =
      zio.aws.networkmanager.model.primitives.DeviceId(impl.deviceId())
    override val connectedDeviceId: DeviceId =
      zio.aws.networkmanager.model.primitives.DeviceId(impl.connectedDeviceId())
    override val linkId: Option[LinkId] = scala
      .Option(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val connectedLinkId: Option[LinkId] = scala
      .Option(impl.connectedLinkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateConnectionRequest
  ): zio.aws.networkmanager.model.CreateConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
