package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.ServerSideString
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CoreNetworkPolicyError(
    errorCode: ServerSideString,
    message: ServerSideString,
    path: Option[ServerSideString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyError = {
    import CoreNetworkPolicyError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyError
      .builder()
      .errorCode(ServerSideString.unwrap(errorCode): java.lang.String)
      .message(ServerSideString.unwrap(message): java.lang.String)
      .optionallyWith(
        path.map(value => ServerSideString.unwrap(value): java.lang.String)
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkPolicyError.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkPolicyError.wrap(buildAwsValue())
}
object CoreNetworkPolicyError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkPolicyError =
      zio.aws.networkmanager.model
        .CoreNetworkPolicyError(errorCode, message, path.map(value => value))
    def errorCode: ServerSideString
    def message: ServerSideString
    def path: Option[ServerSideString]
    def getErrorCode: ZIO[Any, Nothing, ServerSideString] =
      ZIO.succeed(errorCode)
    def getMessage: ZIO[Any, Nothing, ServerSideString] = ZIO.succeed(message)
    def getPath: ZIO[Any, AwsError, ServerSideString] =
      AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyError
  ) extends zio.aws.networkmanager.model.CoreNetworkPolicyError.ReadOnly {
    override val errorCode: ServerSideString =
      zio.aws.networkmanager.model.primitives.ServerSideString(impl.errorCode())
    override val message: ServerSideString =
      zio.aws.networkmanager.model.primitives.ServerSideString(impl.message())
    override val path: Option[ServerSideString] = scala
      .Option(impl.path())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ServerSideString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyError
  ): zio.aws.networkmanager.model.CoreNetworkPolicyError.ReadOnly = new Wrapper(
    impl
  )
}
