package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  DateTime,
  AWSAccountId,
  Integer,
  CoreNetworkArn,
  AttachmentId,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class Attachment(
    coreNetworkId: Option[CoreNetworkId] = None,
    coreNetworkArn: Option[CoreNetworkArn] = None,
    attachmentId: Option[AttachmentId] = None,
    ownerAccountId: Option[AWSAccountId] = None,
    attachmentType: Option[zio.aws.networkmanager.model.AttachmentType] = None,
    state: Option[zio.aws.networkmanager.model.AttachmentState] = None,
    edgeLocation: Option[ExternalRegionCode] = None,
    resourceArn: Option[ResourceArn] = None,
    attachmentPolicyRuleNumber: Option[Integer] = None,
    segmentName: Option[ConstrainedString] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None,
    proposedSegmentChange: Option[
      zio.aws.networkmanager.model.ProposedSegmentChange
    ] = None,
    createdAt: Option[DateTime] = None,
    updatedAt: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Attachment = {
    import Attachment.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Attachment
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        attachmentId.map(value => AttachmentId.unwrap(value): java.lang.String)
      )(_.attachmentId)
      .optionallyWith(
        ownerAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(attachmentType.map(value => value.unwrap))(
        _.attachmentType
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        attachmentPolicyRuleNumber.map(value =>
          Integer.unwrap(value): java.lang.Integer
        )
      )(_.attachmentPolicyRuleNumber)
      .optionallyWith(
        segmentName.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        proposedSegmentChange.map(value => value.buildAwsValue())
      )(_.proposedSegmentChange)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => DateTime.unwrap(value): Instant))(
        _.updatedAt
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Attachment.ReadOnly =
    zio.aws.networkmanager.model.Attachment.wrap(buildAwsValue())
}
object Attachment {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Attachment
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Attachment =
      zio.aws.networkmanager.model.Attachment(
        coreNetworkId.map(value => value),
        coreNetworkArn.map(value => value),
        attachmentId.map(value => value),
        ownerAccountId.map(value => value),
        attachmentType.map(value => value),
        state.map(value => value),
        edgeLocation.map(value => value),
        resourceArn.map(value => value),
        attachmentPolicyRuleNumber.map(value => value),
        segmentName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        proposedSegmentChange.map(value => value.asEditable),
        createdAt.map(value => value),
        updatedAt.map(value => value)
      )
    def coreNetworkId: Option[CoreNetworkId]
    def coreNetworkArn: Option[CoreNetworkArn]
    def attachmentId: Option[AttachmentId]
    def ownerAccountId: Option[AWSAccountId]
    def attachmentType: Option[zio.aws.networkmanager.model.AttachmentType]
    def state: Option[zio.aws.networkmanager.model.AttachmentState]
    def edgeLocation: Option[ExternalRegionCode]
    def resourceArn: Option[ResourceArn]
    def attachmentPolicyRuleNumber: Option[Integer]
    def segmentName: Option[ConstrainedString]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def proposedSegmentChange
        : Option[zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly]
    def createdAt: Option[DateTime]
    def updatedAt: Option[DateTime]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getOwnerAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getAttachmentType
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentType] =
      AwsError.unwrapOptionField("attachmentType", attachmentType)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.AttachmentState] =
      AwsError.unwrapOptionField("state", state)
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getAttachmentPolicyRuleNumber: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "attachmentPolicyRuleNumber",
        attachmentPolicyRuleNumber
      )
    def getSegmentName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProposedSegmentChange: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly
    ] =
      AwsError.unwrapOptionField("proposedSegmentChange", proposedSegmentChange)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Attachment
  ) extends zio.aws.networkmanager.model.Attachment.ReadOnly {
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val coreNetworkArn: Option[CoreNetworkArn] = scala
      .Option(impl.coreNetworkArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkArn(value)
      )
    override val attachmentId: Option[AttachmentId] = scala
      .Option(impl.attachmentId())
      .map(value => zio.aws.networkmanager.model.primitives.AttachmentId(value))
    override val ownerAccountId: Option[AWSAccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val attachmentType
        : Option[zio.aws.networkmanager.model.AttachmentType] = scala
      .Option(impl.attachmentType())
      .map(value => zio.aws.networkmanager.model.AttachmentType.wrap(value))
    override val state: Option[zio.aws.networkmanager.model.AttachmentState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.networkmanager.model.AttachmentState.wrap(value))
    override val edgeLocation: Option[ExternalRegionCode] = scala
      .Option(impl.edgeLocation())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val resourceArn: Option[ResourceArn] = scala
      .Option(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val attachmentPolicyRuleNumber: Option[Integer] = scala
      .Option(impl.attachmentPolicyRuleNumber())
      .map(value => zio.aws.networkmanager.model.primitives.Integer(value))
    override val segmentName: Option[ConstrainedString] = scala
      .Option(impl.segmentName())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val proposedSegmentChange
        : Option[zio.aws.networkmanager.model.ProposedSegmentChange.ReadOnly] =
      scala
        .Option(impl.proposedSegmentChange())
        .map(value =>
          zio.aws.networkmanager.model.ProposedSegmentChange.wrap(value)
        )
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val updatedAt: Option[DateTime] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Attachment
  ): zio.aws.networkmanager.model.Attachment.ReadOnly = new Wrapper(impl)
}
