package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RouteAnalysisPath(
    completionStatus: Option[
      zio.aws.networkmanager.model.RouteAnalysisCompletion
    ] = None,
    path: Option[Iterable[zio.aws.networkmanager.model.PathComponent]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath = {
    import RouteAnalysisPath.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
      .builder()
      .optionallyWith(completionStatus.map(value => value.buildAwsValue()))(
        _.completionStatus
      )
      .optionallyWith(
        path.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.path)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisPath.wrap(buildAwsValue())
}
object RouteAnalysisPath {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteAnalysisPath =
      zio.aws.networkmanager.model.RouteAnalysisPath(
        completionStatus.map(value => value.asEditable),
        path.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def completionStatus
        : Option[zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly]
    def path: Option[List[zio.aws.networkmanager.model.PathComponent.ReadOnly]]
    def getCompletionStatus: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly
    ] = AwsError.unwrapOptionField("completionStatus", completionStatus)
    def getPath: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.PathComponent.ReadOnly
    ]] = AwsError.unwrapOptionField("path", path)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
  ) extends zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly {
    override val completionStatus: Option[
      zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly
    ] = scala
      .Option(impl.completionStatus())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisCompletion.wrap(value)
      )
    override val path
        : Option[List[zio.aws.networkmanager.model.PathComponent.ReadOnly]] =
      scala
        .Option(impl.path())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.PathComponent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisPath
  ): zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly = new Wrapper(impl)
}
