package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  IPAddress,
  TransitGatewayAttachmentArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RouteAnalysisEndpointOptionsSpecification(
    transitGatewayAttachmentArn: Option[TransitGatewayAttachmentArn] = None,
    ipAddress: Option[IPAddress] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification = {
    import RouteAnalysisEndpointOptionsSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
      .builder()
      .optionallyWith(
        transitGatewayAttachmentArn.map(value =>
          TransitGatewayAttachmentArn.unwrap(value): java.lang.String
        )
      )(_.transitGatewayAttachmentArn)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
      .wrap(buildAwsValue())
}
object RouteAnalysisEndpointOptionsSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification =
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification(
        transitGatewayAttachmentArn.map(value => value),
        ipAddress.map(value => value)
      )
    def transitGatewayAttachmentArn: Option[TransitGatewayAttachmentArn]
    def ipAddress: Option[IPAddress]
    def getTransitGatewayAttachmentArn
        : ZIO[Any, AwsError, TransitGatewayAttachmentArn] =
      AwsError.unwrapOptionField(
        "transitGatewayAttachmentArn",
        transitGatewayAttachmentArn
      )
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
  ) extends zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly {
    override val transitGatewayAttachmentArn
        : Option[TransitGatewayAttachmentArn] = scala
      .Option(impl.transitGatewayAttachmentArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives
          .TransitGatewayAttachmentArn(value)
      )
    override val ipAddress: Option[IPAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.networkmanager.model.primitives.IPAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisEndpointOptionsSpecification
  ): zio.aws.networkmanager.model.RouteAnalysisEndpointOptionsSpecification.ReadOnly =
    new Wrapper(impl)
}
