package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  DateTime,
  ConstrainedString,
  AWSAccountId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RouteAnalysis(
    globalNetworkId: Option[GlobalNetworkId] = None,
    ownerAccountId: Option[AWSAccountId] = None,
    routeAnalysisId: Option[ConstrainedString] = None,
    startTimestamp: Option[DateTime] = None,
    status: Option[zio.aws.networkmanager.model.RouteAnalysisStatus] = None,
    source: Option[zio.aws.networkmanager.model.RouteAnalysisEndpointOptions] =
      None,
    destination: Option[
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions
    ] = None,
    includeReturnPath: Option[Boolean] = None,
    useMiddleboxes: Option[Boolean] = None,
    forwardPath: Option[zio.aws.networkmanager.model.RouteAnalysisPath] = None,
    returnPath: Option[zio.aws.networkmanager.model.RouteAnalysisPath] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysis = {
    import RouteAnalysis.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysis
      .builder()
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        ownerAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(
        routeAnalysisId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.routeAnalysisId)
      .optionallyWith(
        startTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.startTimestamp)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(destination.map(value => value.buildAwsValue()))(
        _.destination
      )
      .optionallyWith(includeReturnPath.map(value => value: java.lang.Boolean))(
        _.includeReturnPath
      )
      .optionallyWith(useMiddleboxes.map(value => value: java.lang.Boolean))(
        _.useMiddleboxes
      )
      .optionallyWith(forwardPath.map(value => value.buildAwsValue()))(
        _.forwardPath
      )
      .optionallyWith(returnPath.map(value => value.buildAwsValue()))(
        _.returnPath
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.RouteAnalysis.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysis.wrap(buildAwsValue())
}
object RouteAnalysis {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysis
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteAnalysis =
      zio.aws.networkmanager.model.RouteAnalysis(
        globalNetworkId.map(value => value),
        ownerAccountId.map(value => value),
        routeAnalysisId.map(value => value),
        startTimestamp.map(value => value),
        status.map(value => value),
        source.map(value => value.asEditable),
        destination.map(value => value.asEditable),
        includeReturnPath.map(value => value),
        useMiddleboxes.map(value => value),
        forwardPath.map(value => value.asEditable),
        returnPath.map(value => value.asEditable)
      )
    def globalNetworkId: Option[GlobalNetworkId]
    def ownerAccountId: Option[AWSAccountId]
    def routeAnalysisId: Option[ConstrainedString]
    def startTimestamp: Option[DateTime]
    def status: Option[zio.aws.networkmanager.model.RouteAnalysisStatus]
    def source: Option[
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly
    ]
    def destination: Option[
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly
    ]
    def includeReturnPath: Option[Boolean]
    def useMiddleboxes: Option[Boolean]
    def forwardPath
        : Option[zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly]
    def returnPath
        : Option[zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly]
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getOwnerAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getRouteAnalysisId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("routeAnalysisId", routeAnalysisId)
    def getStartTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTimestamp", startTimestamp)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.RouteAnalysisStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
    def getDestination: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly
    ] = AwsError.unwrapOptionField("destination", destination)
    def getIncludeReturnPath: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeReturnPath", includeReturnPath)
    def getUseMiddleboxes: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("useMiddleboxes", useMiddleboxes)
    def getForwardPath: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly
    ] = AwsError.unwrapOptionField("forwardPath", forwardPath)
    def getReturnPath: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly
    ] = AwsError.unwrapOptionField("returnPath", returnPath)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysis
  ) extends zio.aws.networkmanager.model.RouteAnalysis.ReadOnly {
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val ownerAccountId: Option[AWSAccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val routeAnalysisId: Option[ConstrainedString] = scala
      .Option(impl.routeAnalysisId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val startTimestamp: Option[DateTime] = scala
      .Option(impl.startTimestamp())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val status
        : Option[zio.aws.networkmanager.model.RouteAnalysisStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisStatus.wrap(value)
      )
    override val source: Option[
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly
    ] = scala
      .Option(impl.source())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.wrap(value)
      )
    override val destination: Option[
      zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.ReadOnly
    ] = scala
      .Option(impl.destination())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisEndpointOptions.wrap(value)
      )
    override val includeReturnPath: Option[Boolean] =
      scala.Option(impl.includeReturnPath()).map(value => value: Boolean)
    override val useMiddleboxes: Option[Boolean] =
      scala.Option(impl.useMiddleboxes()).map(value => value: Boolean)
    override val forwardPath
        : Option[zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly] =
      scala
        .Option(impl.forwardPath())
        .map(value =>
          zio.aws.networkmanager.model.RouteAnalysisPath.wrap(value)
        )
    override val returnPath
        : Option[zio.aws.networkmanager.model.RouteAnalysisPath.ReadOnly] =
      scala
        .Option(impl.returnPath())
        .map(value =>
          zio.aws.networkmanager.model.RouteAnalysisPath.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysis
  ): zio.aws.networkmanager.model.RouteAnalysis.ReadOnly = new Wrapper(impl)
}
