package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ResourceArn,
  ResourcePolicyDocument
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutResourcePolicyRequest(
    policyDocument: ResourcePolicyDocument,
    resourceArn: ResourceArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest = {
    import PutResourcePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest
      .builder()
      .policyDocument(
        ResourcePolicyDocument.unwrap(policyDocument): java.lang.String
      )
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.PutResourcePolicyRequest.ReadOnly =
    zio.aws.networkmanager.model.PutResourcePolicyRequest.wrap(buildAwsValue())
}
object PutResourcePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.PutResourcePolicyRequest =
      zio.aws.networkmanager.model
        .PutResourcePolicyRequest(policyDocument, resourceArn)
    def policyDocument: ResourcePolicyDocument
    def resourceArn: ResourceArn
    def getPolicyDocument: ZIO[Any, Nothing, ResourcePolicyDocument] =
      ZIO.succeed(policyDocument)
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest
  ) extends zio.aws.networkmanager.model.PutResourcePolicyRequest.ReadOnly {
    override val policyDocument: ResourcePolicyDocument =
      zio.aws.networkmanager.model.primitives
        .ResourcePolicyDocument(impl.policyDocument())
    override val resourceArn: ResourceArn =
      zio.aws.networkmanager.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.PutResourcePolicyRequest
  ): zio.aws.networkmanager.model.PutResourcePolicyRequest.ReadOnly =
    new Wrapper(impl)
}
