package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  ConnectPeerId,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetConnectPeerAssociationsRequest(
    globalNetworkId: GlobalNetworkId,
    connectPeerIds: Option[Iterable[ConnectPeerId]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest = {
    import GetConnectPeerAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        connectPeerIds.map(value =>
          value.map { item =>
            ConnectPeerId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectPeerIds)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetConnectPeerAssociationsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetConnectPeerAssociationsRequest
      .wrap(buildAwsValue())
}
object GetConnectPeerAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetConnectPeerAssociationsRequest =
      zio.aws.networkmanager.model.GetConnectPeerAssociationsRequest(
        globalNetworkId,
        connectPeerIds.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def connectPeerIds: Option[List[ConnectPeerId]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getConnectPeerIds: ZIO[Any, AwsError, List[ConnectPeerId]] =
      AwsError.unwrapOptionField("connectPeerIds", connectPeerIds)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest
  ) extends zio.aws.networkmanager.model.GetConnectPeerAssociationsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val connectPeerIds: Option[List[ConnectPeerId]] = scala
      .Option(impl.connectPeerIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.ConnectPeerId(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectPeerAssociationsRequest
  ): zio.aws.networkmanager.model.GetConnectPeerAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
