package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  DateTime,
  ConstrainedString,
  Integer,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CoreNetworkPolicyVersion(
    coreNetworkId: Option[CoreNetworkId] = None,
    policyVersionId: Option[Integer] = None,
    alias: Option[zio.aws.networkmanager.model.CoreNetworkPolicyAlias] = None,
    description: Option[ConstrainedString] = None,
    createdAt: Option[DateTime] = None,
    changeSetState: Option[zio.aws.networkmanager.model.ChangeSetState] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion = {
    import CoreNetworkPolicyVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        policyVersionId.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.policyVersionId)
      .optionallyWith(alias.map(value => value.unwrap))(_.alias)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(changeSetState.map(value => value.unwrap))(
        _.changeSetState
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkPolicyVersion.wrap(buildAwsValue())
}
object CoreNetworkPolicyVersion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkPolicyVersion =
      zio.aws.networkmanager.model.CoreNetworkPolicyVersion(
        coreNetworkId.map(value => value),
        policyVersionId.map(value => value),
        alias.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        changeSetState.map(value => value)
      )
    def coreNetworkId: Option[CoreNetworkId]
    def policyVersionId: Option[Integer]
    def alias: Option[zio.aws.networkmanager.model.CoreNetworkPolicyAlias]
    def description: Option[ConstrainedString]
    def createdAt: Option[DateTime]
    def changeSetState: Option[zio.aws.networkmanager.model.ChangeSetState]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getPolicyVersionId: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("policyVersionId", policyVersionId)
    def getAlias: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkPolicyAlias
    ] = AwsError.unwrapOptionField("alias", alias)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getChangeSetState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.ChangeSetState] =
      AwsError.unwrapOptionField("changeSetState", changeSetState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion
  ) extends zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly {
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val policyVersionId: Option[Integer] = scala
      .Option(impl.policyVersionId())
      .map(value => zio.aws.networkmanager.model.primitives.Integer(value))
    override val alias
        : Option[zio.aws.networkmanager.model.CoreNetworkPolicyAlias] = scala
      .Option(impl.alias())
      .map(value =>
        zio.aws.networkmanager.model.CoreNetworkPolicyAlias.wrap(value)
      )
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val changeSetState
        : Option[zio.aws.networkmanager.model.ChangeSetState] = scala
      .Option(impl.changeSetState())
      .map(value => zio.aws.networkmanager.model.ChangeSetState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion
  ): zio.aws.networkmanager.model.CoreNetworkPolicyVersion.ReadOnly =
    new Wrapper(impl)
}
