package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId,
  DateTime,
  CoreNetworkArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CoreNetwork(
    globalNetworkId: Option[GlobalNetworkId] = None,
    coreNetworkId: Option[CoreNetworkId] = None,
    coreNetworkArn: Option[CoreNetworkArn] = None,
    description: Option[ConstrainedString] = None,
    createdAt: Option[DateTime] = None,
    state: Option[zio.aws.networkmanager.model.CoreNetworkState] = None,
    segments: Option[
      Iterable[zio.aws.networkmanager.model.CoreNetworkSegment]
    ] = None,
    edges: Option[Iterable[zio.aws.networkmanager.model.CoreNetworkEdge]] =
      None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetwork = {
    import CoreNetwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetwork
      .builder()
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        segments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.segments)
      .optionallyWith(
        edges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.edges)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetwork.ReadOnly =
    zio.aws.networkmanager.model.CoreNetwork.wrap(buildAwsValue())
}
object CoreNetwork {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetwork
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetwork =
      zio.aws.networkmanager.model.CoreNetwork(
        globalNetworkId.map(value => value),
        coreNetworkId.map(value => value),
        coreNetworkArn.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        state.map(value => value),
        segments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        edges.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: Option[GlobalNetworkId]
    def coreNetworkId: Option[CoreNetworkId]
    def coreNetworkArn: Option[CoreNetworkArn]
    def description: Option[ConstrainedString]
    def createdAt: Option[DateTime]
    def state: Option[zio.aws.networkmanager.model.CoreNetworkState]
    def segments
        : Option[List[zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly]]
    def edges
        : Option[List[zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly]]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.CoreNetworkState] =
      AwsError.unwrapOptionField("state", state)
    def getSegments: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly
    ]] = AwsError.unwrapOptionField("segments", segments)
    def getEdges: ZIO[Any, AwsError, List[
      zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly
    ]] = AwsError.unwrapOptionField("edges", edges)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetwork
  ) extends zio.aws.networkmanager.model.CoreNetwork.ReadOnly {
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val coreNetworkArn: Option[CoreNetworkArn] = scala
      .Option(impl.coreNetworkArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkArn(value)
      )
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state: Option[zio.aws.networkmanager.model.CoreNetworkState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.networkmanager.model.CoreNetworkState.wrap(value))
    override val segments: Option[
      List[zio.aws.networkmanager.model.CoreNetworkSegment.ReadOnly]
    ] = scala
      .Option(impl.segments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.CoreNetworkSegment.wrap(item)
        }.toList
      )
    override val edges
        : Option[List[zio.aws.networkmanager.model.CoreNetworkEdge.ReadOnly]] =
      scala
        .Option(impl.edges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.CoreNetworkEdge.wrap(item)
          }.toList
        )
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetwork
  ): zio.aws.networkmanager.model.CoreNetwork.ReadOnly = new Wrapper(impl)
}
