package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ReasonContextValue,
  ReasonContextKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RouteAnalysisCompletion(
    resultCode: Option[
      zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
    ] = None,
    reasonCode: Option[
      zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
    ] = None,
    reasonContext: Option[Map[ReasonContextKey, ReasonContextValue]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion = {
    import RouteAnalysisCompletion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
      .builder()
      .optionallyWith(resultCode.map(value => value.unwrap))(_.resultCode)
      .optionallyWith(reasonCode.map(value => value.unwrap))(_.reasonCode)
      .optionallyWith(
        reasonContext.map(value =>
          value
            .map({ case (key, value) =>
              (ReasonContextKey
                .unwrap(key): java.lang.String) -> (ReasonContextValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.reasonContext)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly =
    zio.aws.networkmanager.model.RouteAnalysisCompletion.wrap(buildAwsValue())
}
object RouteAnalysisCompletion {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.RouteAnalysisCompletion =
      zio.aws.networkmanager.model.RouteAnalysisCompletion(
        resultCode.map(value => value),
        reasonCode.map(value => value),
        reasonContext.map(value => value)
      )
    def resultCode
        : Option[zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode]
    def reasonCode
        : Option[zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode]
    def reasonContext: Option[Map[ReasonContextKey, ReasonContextValue]]
    def getResultCode: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
    ] = AwsError.unwrapOptionField("resultCode", resultCode)
    def getReasonCode: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
    ] = AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getReasonContext
        : ZIO[Any, AwsError, Map[ReasonContextKey, ReasonContextValue]] =
      AwsError.unwrapOptionField("reasonContext", reasonContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
  ) extends zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly {
    override val resultCode: Option[
      zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
    ] = scala
      .Option(impl.resultCode())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisCompletionResultCode
          .wrap(value)
      )
    override val reasonCode: Option[
      zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
    ] = scala
      .Option(impl.reasonCode())
      .map(value =>
        zio.aws.networkmanager.model.RouteAnalysisCompletionReasonCode
          .wrap(value)
      )
    override val reasonContext
        : Option[Map[ReasonContextKey, ReasonContextValue]] = scala
      .Option(impl.reasonContext())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkmanager.model.primitives
              .ReasonContextKey(key) -> zio.aws.networkmanager.model.primitives
              .ReasonContextValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.RouteAnalysisCompletion
  ): zio.aws.networkmanager.model.RouteAnalysisCompletion.ReadOnly =
    new Wrapper(impl)
}
