package zio.aws.networkmanager.model
import java.lang.Integer
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  AttachmentId,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListConnectPeersRequest(
    coreNetworkId: Option[CoreNetworkId] = None,
    connectAttachmentId: Option[AttachmentId] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest = {
    import ListConnectPeersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        connectAttachmentId.map(value =>
          AttachmentId.unwrap(value): java.lang.String
        )
      )(_.connectAttachmentId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.ListConnectPeersRequest.ReadOnly =
    zio.aws.networkmanager.model.ListConnectPeersRequest.wrap(buildAwsValue())
}
object ListConnectPeersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.ListConnectPeersRequest =
      zio.aws.networkmanager.model.ListConnectPeersRequest(
        coreNetworkId.map(value => value),
        connectAttachmentId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def coreNetworkId: Option[CoreNetworkId]
    def connectAttachmentId: Option[AttachmentId]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getConnectAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("connectAttachmentId", connectAttachmentId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
  ) extends zio.aws.networkmanager.model.ListConnectPeersRequest.ReadOnly {
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val connectAttachmentId: Option[AttachmentId] = scala
      .Option(impl.connectAttachmentId())
      .map(value => zio.aws.networkmanager.model.primitives.AttachmentId(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.ListConnectPeersRequest
  ): zio.aws.networkmanager.model.ListConnectPeersRequest.ReadOnly =
    new Wrapper(impl)
}
