package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  DateTime,
  ConstrainedString,
  GlobalNetworkArn,
  GlobalNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class GlobalNetwork(
    globalNetworkId: Option[GlobalNetworkId] = None,
    globalNetworkArn: Option[GlobalNetworkArn] = None,
    description: Option[ConstrainedString] = None,
    createdAt: Option[DateTime] = None,
    state: Option[zio.aws.networkmanager.model.GlobalNetworkState] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GlobalNetwork = {
    import GlobalNetwork.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GlobalNetwork
      .builder()
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        globalNetworkArn.map(value =>
          GlobalNetworkArn.unwrap(value): java.lang.String
        )
      )(_.globalNetworkArn)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GlobalNetwork.ReadOnly =
    zio.aws.networkmanager.model.GlobalNetwork.wrap(buildAwsValue())
}
object GlobalNetwork {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GlobalNetwork
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GlobalNetwork =
      zio.aws.networkmanager.model.GlobalNetwork(
        globalNetworkId.map(value => value),
        globalNetworkArn.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def globalNetworkId: Option[GlobalNetworkId]
    def globalNetworkArn: Option[GlobalNetworkArn]
    def description: Option[ConstrainedString]
    def createdAt: Option[DateTime]
    def state: Option[zio.aws.networkmanager.model.GlobalNetworkState]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getGlobalNetworkArn: ZIO[Any, AwsError, GlobalNetworkArn] =
      AwsError.unwrapOptionField("globalNetworkArn", globalNetworkArn)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.GlobalNetworkState] =
      AwsError.unwrapOptionField("state", state)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GlobalNetwork
  ) extends zio.aws.networkmanager.model.GlobalNetwork.ReadOnly {
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val globalNetworkArn: Option[GlobalNetworkArn] = scala
      .Option(impl.globalNetworkArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkArn(value)
      )
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val createdAt: Option[DateTime] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state
        : Option[zio.aws.networkmanager.model.GlobalNetworkState] = scala
      .Option(impl.state())
      .map(value => zio.aws.networkmanager.model.GlobalNetworkState.wrap(value))
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GlobalNetwork
  ): zio.aws.networkmanager.model.GlobalNetwork.ReadOnly = new Wrapper(impl)
}
