package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetSiteToSiteVpnAttachmentRequest(attachmentId: AttachmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest = {
    import GetSiteToSiteVpnAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentRequest
      .wrap(buildAwsValue())
}
object GetSiteToSiteVpnAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentRequest =
      zio.aws.networkmanager.model
        .GetSiteToSiteVpnAttachmentRequest(attachmentId)
    def attachmentId: AttachmentId
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest
  ) extends zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetSiteToSiteVpnAttachmentRequest
  ): zio.aws.networkmanager.model.GetSiteToSiteVpnAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
