package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDeviceResponse(
    device: Option[zio.aws.networkmanager.model.Device] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse = {
    import DeleteDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse
      .builder()
      .optionallyWith(device.map(value => value.buildAwsValue()))(_.device)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteDeviceResponse.wrap(buildAwsValue())
}
object DeleteDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteDeviceResponse =
      zio.aws.networkmanager.model
        .DeleteDeviceResponse(device.map(value => value.asEditable))
    def device: Option[zio.aws.networkmanager.model.Device.ReadOnly]
    def getDevice
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Device.ReadOnly] =
      AwsError.unwrapOptionField("device", device)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse
  ) extends zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly {
    override val device: Option[zio.aws.networkmanager.model.Device.ReadOnly] =
      scala
        .Option(impl.device())
        .map(value => zio.aws.networkmanager.model.Device.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteDeviceResponse
  ): zio.aws.networkmanager.model.DeleteDeviceResponse.ReadOnly = new Wrapper(
    impl
  )
}
