package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.AttachmentId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAttachmentRequest(attachmentId: AttachmentId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest = {
    import DeleteAttachmentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest
      .builder()
      .attachmentId(AttachmentId.unwrap(attachmentId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteAttachmentRequest.ReadOnly =
    zio.aws.networkmanager.model.DeleteAttachmentRequest.wrap(buildAwsValue())
}
object DeleteAttachmentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeleteAttachmentRequest =
      zio.aws.networkmanager.model.DeleteAttachmentRequest(attachmentId)
    def attachmentId: AttachmentId
    def getAttachmentId: ZIO[Any, Nothing, AttachmentId] =
      ZIO.succeed(attachmentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest
  ) extends zio.aws.networkmanager.model.DeleteAttachmentRequest.ReadOnly {
    override val attachmentId: AttachmentId =
      zio.aws.networkmanager.model.primitives.AttachmentId(impl.attachmentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteAttachmentRequest
  ): zio.aws.networkmanager.model.DeleteAttachmentRequest.ReadOnly =
    new Wrapper(impl)
}
