package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  LinkId,
  DeviceId,
  GlobalNetworkId,
  CustomerGatewayArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CustomerGatewayAssociation(
    customerGatewayArn: Option[CustomerGatewayArn] = None,
    globalNetworkId: Option[GlobalNetworkId] = None,
    deviceId: Option[DeviceId] = None,
    linkId: Option[LinkId] = None,
    state: Option[
      zio.aws.networkmanager.model.CustomerGatewayAssociationState
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation = {
    import CustomerGatewayAssociation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
      .builder()
      .optionallyWith(
        customerGatewayArn.map(value =>
          CustomerGatewayArn.unwrap(value): java.lang.String
        )
      )(_.customerGatewayArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        linkId.map(value => LinkId.unwrap(value): java.lang.String)
      )(_.linkId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly =
    zio.aws.networkmanager.model.CustomerGatewayAssociation
      .wrap(buildAwsValue())
}
object CustomerGatewayAssociation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CustomerGatewayAssociation =
      zio.aws.networkmanager.model.CustomerGatewayAssociation(
        customerGatewayArn.map(value => value),
        globalNetworkId.map(value => value),
        deviceId.map(value => value),
        linkId.map(value => value),
        state.map(value => value)
      )
    def customerGatewayArn: Option[CustomerGatewayArn]
    def globalNetworkId: Option[GlobalNetworkId]
    def deviceId: Option[DeviceId]
    def linkId: Option[LinkId]
    def state
        : Option[zio.aws.networkmanager.model.CustomerGatewayAssociationState]
    def getCustomerGatewayArn: ZIO[Any, AwsError, CustomerGatewayArn] =
      AwsError.unwrapOptionField("customerGatewayArn", customerGatewayArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLinkId: ZIO[Any, AwsError, LinkId] =
      AwsError.unwrapOptionField("linkId", linkId)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CustomerGatewayAssociationState
    ] = AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
  ) extends zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly {
    override val customerGatewayArn: Option[CustomerGatewayArn] = scala
      .Option(impl.customerGatewayArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CustomerGatewayArn(value)
      )
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val deviceId: Option[DeviceId] = scala
      .Option(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val linkId: Option[LinkId] = scala
      .Option(impl.linkId())
      .map(value => zio.aws.networkmanager.model.primitives.LinkId(value))
    override val state
        : Option[zio.aws.networkmanager.model.CustomerGatewayAssociationState] =
      scala
        .Option(impl.state())
        .map(value =>
          zio.aws.networkmanager.model.CustomerGatewayAssociationState
            .wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CustomerGatewayAssociation
  ): zio.aws.networkmanager.model.CustomerGatewayAssociation.ReadOnly =
    new Wrapper(impl)
}
