package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  GlobalNetworkId,
  AWSAccountId,
  CoreNetworkArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CoreNetworkSummary(
    coreNetworkId: Option[CoreNetworkId] = None,
    coreNetworkArn: Option[CoreNetworkArn] = None,
    globalNetworkId: Option[GlobalNetworkId] = None,
    ownerAccountId: Option[AWSAccountId] = None,
    state: Option[zio.aws.networkmanager.model.CoreNetworkState] = None,
    description: Option[ConstrainedString] = None,
    tags: Option[Iterable[zio.aws.networkmanager.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary = {
    import CoreNetworkSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
      .builder()
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        coreNetworkArn.map(value =>
          CoreNetworkArn.unwrap(value): java.lang.String
        )
      )(_.coreNetworkArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(
        ownerAccountId.map(value =>
          AWSAccountId.unwrap(value): java.lang.String
        )
      )(_.ownerAccountId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkSummary.wrap(buildAwsValue())
}
object CoreNetworkSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkSummary =
      zio.aws.networkmanager.model.CoreNetworkSummary(
        coreNetworkId.map(value => value),
        coreNetworkArn.map(value => value),
        globalNetworkId.map(value => value),
        ownerAccountId.map(value => value),
        state.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def coreNetworkId: Option[CoreNetworkId]
    def coreNetworkArn: Option[CoreNetworkArn]
    def globalNetworkId: Option[GlobalNetworkId]
    def ownerAccountId: Option[AWSAccountId]
    def state: Option[zio.aws.networkmanager.model.CoreNetworkState]
    def description: Option[ConstrainedString]
    def tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getCoreNetworkArn: ZIO[Any, AwsError, CoreNetworkArn] =
      AwsError.unwrapOptionField("coreNetworkArn", coreNetworkArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getOwnerAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("ownerAccountId", ownerAccountId)
    def getState
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.CoreNetworkState] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
  ) extends zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly {
    override val coreNetworkId: Option[CoreNetworkId] = scala
      .Option(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val coreNetworkArn: Option[CoreNetworkArn] = scala
      .Option(impl.coreNetworkArn())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkArn(value)
      )
    override val globalNetworkId: Option[GlobalNetworkId] = scala
      .Option(impl.globalNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
      )
    override val ownerAccountId: Option[AWSAccountId] = scala
      .Option(impl.ownerAccountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val state: Option[zio.aws.networkmanager.model.CoreNetworkState] =
      scala
        .Option(impl.state())
        .map(value => zio.aws.networkmanager.model.CoreNetworkState.wrap(value))
    override val description: Option[ConstrainedString] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val tags: Option[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkSummary
  ): zio.aws.networkmanager.model.CoreNetworkSummary.ReadOnly = new Wrapper(
    impl
  )
}
