package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ChangeSetState {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.ChangeSetState
}
object ChangeSetState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ChangeSetState
  ): zio.aws.networkmanager.model.ChangeSetState = value match {
    case software.amazon.awssdk.services.networkmanager.model.ChangeSetState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeSetState.PENDING_GENERATION =>
      val r = PENDING_GENERATION
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeSetState.FAILED_GENERATION =>
      val r = FAILED_GENERATION
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeSetState.READY_TO_EXECUTE =>
      val r = READY_TO_EXECUTE
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeSetState.EXECUTING =>
      val r = EXECUTING
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeSetState.EXECUTION_SUCCEEDED =>
      val r = EXECUTION_SUCCEEDED
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeSetState.OUT_OF_DATE =>
      val r = OUT_OF_DATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ChangeSetState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeSetState =
      software.amazon.awssdk.services.networkmanager.model.ChangeSetState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING_GENERATION
      extends zio.aws.networkmanager.model.ChangeSetState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeSetState =
      software.amazon.awssdk.services.networkmanager.model.ChangeSetState.PENDING_GENERATION
  }
  case object FAILED_GENERATION
      extends zio.aws.networkmanager.model.ChangeSetState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeSetState =
      software.amazon.awssdk.services.networkmanager.model.ChangeSetState.FAILED_GENERATION
  }
  case object READY_TO_EXECUTE
      extends zio.aws.networkmanager.model.ChangeSetState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeSetState =
      software.amazon.awssdk.services.networkmanager.model.ChangeSetState.READY_TO_EXECUTE
  }
  case object EXECUTING extends zio.aws.networkmanager.model.ChangeSetState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeSetState =
      software.amazon.awssdk.services.networkmanager.model.ChangeSetState.EXECUTING
  }
  case object EXECUTION_SUCCEEDED
      extends zio.aws.networkmanager.model.ChangeSetState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeSetState =
      software.amazon.awssdk.services.networkmanager.model.ChangeSetState.EXECUTION_SUCCEEDED
  }
  case object OUT_OF_DATE extends zio.aws.networkmanager.model.ChangeSetState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeSetState =
      software.amazon.awssdk.services.networkmanager.model.ChangeSetState.OUT_OF_DATE
  }
}
