package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Bandwidth(
    uploadSpeed: Option[Integer] = None,
    downloadSpeed: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Bandwidth = {
    import Bandwidth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Bandwidth
      .builder()
      .optionallyWith(
        uploadSpeed.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.uploadSpeed)
      .optionallyWith(
        downloadSpeed.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.downloadSpeed)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Bandwidth.ReadOnly =
    zio.aws.networkmanager.model.Bandwidth.wrap(buildAwsValue())
}
object Bandwidth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Bandwidth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Bandwidth =
      zio.aws.networkmanager.model.Bandwidth(
        uploadSpeed.map(value => value),
        downloadSpeed.map(value => value)
      )
    def uploadSpeed: Option[Integer]
    def downloadSpeed: Option[Integer]
    def getUploadSpeed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("uploadSpeed", uploadSpeed)
    def getDownloadSpeed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("downloadSpeed", downloadSpeed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Bandwidth
  ) extends zio.aws.networkmanager.model.Bandwidth.ReadOnly {
    override val uploadSpeed: Option[Integer] = scala
      .Option(impl.uploadSpeed())
      .map(value => zio.aws.networkmanager.model.primitives.Integer(value))
    override val downloadSpeed: Option[Integer] = scala
      .Option(impl.downloadSpeed())
      .map(value => zio.aws.networkmanager.model.primitives.Integer(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Bandwidth
  ): zio.aws.networkmanager.model.Bandwidth.ReadOnly = new Wrapper(impl)
}
