package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait ChangeAction {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.ChangeAction
}
object ChangeAction {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ChangeAction
  ): zio.aws.networkmanager.model.ChangeAction = value match {
    case software.amazon.awssdk.services.networkmanager.model.ChangeAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeAction.ADD =>
      val r = ADD
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeAction.MODIFY =>
      val r = MODIFY
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeAction.REMOVE =>
      val r = REMOVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeAction =
      software.amazon.awssdk.services.networkmanager.model.ChangeAction.UNKNOWN_TO_SDK_VERSION
  }
  case object ADD extends zio.aws.networkmanager.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeAction =
      software.amazon.awssdk.services.networkmanager.model.ChangeAction.ADD
  }
  case object MODIFY extends zio.aws.networkmanager.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeAction =
      software.amazon.awssdk.services.networkmanager.model.ChangeAction.MODIFY
  }
  case object REMOVE extends zio.aws.networkmanager.model.ChangeAction {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeAction =
      software.amazon.awssdk.services.networkmanager.model.ChangeAction.REMOVE
  }
}
