package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{SLRDeploymentStatus, AccountId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AccountStatus(
    accountId: Optional[AccountId] = Optional.Absent,
    slrDeploymentStatus: Optional[SLRDeploymentStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.AccountStatus = {
    import AccountStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.AccountStatus
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        slrDeploymentStatus.map(value =>
          SLRDeploymentStatus.unwrap(value): java.lang.String
        )
      )(_.slrDeploymentStatus)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.AccountStatus.ReadOnly =
    zio.aws.networkmanager.model.AccountStatus.wrap(buildAwsValue())
}
object AccountStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.AccountStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.AccountStatus =
      zio.aws.networkmanager.model.AccountStatus(
        accountId.map(value => value),
        slrDeploymentStatus.map(value => value)
      )
    def accountId: Optional[AccountId]
    def slrDeploymentStatus: Optional[SLRDeploymentStatus]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getSlrDeploymentStatus: ZIO[Any, AwsError, SLRDeploymentStatus] =
      AwsError.unwrapOptionField("slrDeploymentStatus", slrDeploymentStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.AccountStatus
  ) extends zio.aws.networkmanager.model.AccountStatus.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.networkmanager.model.primitives.AccountId(value))
    override val slrDeploymentStatus: Optional[SLRDeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.slrDeploymentStatus())
        .map(value =>
          zio.aws.networkmanager.model.primitives.SLRDeploymentStatus(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.AccountStatus
  ): zio.aws.networkmanager.model.AccountStatus.ReadOnly = new Wrapper(impl)
}
