package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  TransitGatewayConnectPeerArn,
  GlobalNetworkId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetTransitGatewayConnectPeerAssociationsRequest(
    globalNetworkId: GlobalNetworkId,
    transitGatewayConnectPeerArns: Optional[
      Iterable[TransitGatewayConnectPeerArn]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest = {
    import GetTransitGatewayConnectPeerAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        transitGatewayConnectPeerArns.map(value =>
          value.map { item =>
            TransitGatewayConnectPeerArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.transitGatewayConnectPeerArns)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
      .wrap(buildAwsValue())
}
object GetTransitGatewayConnectPeerAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest =
      zio.aws.networkmanager.model
        .GetTransitGatewayConnectPeerAssociationsRequest(
          globalNetworkId,
          transitGatewayConnectPeerArns.map(value => value),
          maxResults.map(value => value),
          nextToken.map(value => value)
        )
    def globalNetworkId: GlobalNetworkId
    def transitGatewayConnectPeerArns
        : Optional[List[TransitGatewayConnectPeerArn]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getTransitGatewayConnectPeerArns
        : ZIO[Any, AwsError, List[TransitGatewayConnectPeerArn]] =
      AwsError.unwrapOptionField(
        "transitGatewayConnectPeerArns",
        transitGatewayConnectPeerArns
      )
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
  ) extends zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val transitGatewayConnectPeerArns
        : Optional[List[TransitGatewayConnectPeerArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayConnectPeerArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives
            .TransitGatewayConnectPeerArn(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest
  ): zio.aws.networkmanager.model.GetTransitGatewayConnectPeerAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
