package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  MaxResults,
  CustomerGatewayArn,
  GlobalNetworkId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetCustomerGatewayAssociationsRequest(
    globalNetworkId: GlobalNetworkId,
    customerGatewayArns: Optional[Iterable[CustomerGatewayArn]] =
      Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest = {
    import GetCustomerGatewayAssociationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        customerGatewayArns.map(value =>
          value.map { item =>
            CustomerGatewayArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.customerGatewayArns)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.GetCustomerGatewayAssociationsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetCustomerGatewayAssociationsRequest
      .wrap(buildAwsValue())
}
object GetCustomerGatewayAssociationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.GetCustomerGatewayAssociationsRequest =
      zio.aws.networkmanager.model.GetCustomerGatewayAssociationsRequest(
        globalNetworkId,
        customerGatewayArns.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def customerGatewayArns: Optional[List[CustomerGatewayArn]]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getCustomerGatewayArns: ZIO[Any, AwsError, List[CustomerGatewayArn]] =
      AwsError.unwrapOptionField("customerGatewayArns", customerGatewayArns)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest
  ) extends zio.aws.networkmanager.model.GetCustomerGatewayAssociationsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val customerGatewayArns: Optional[List[CustomerGatewayArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customerGatewayArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.CustomerGatewayArn(item)
          }.toList
        )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetCustomerGatewayAssociationsRequest
  ): zio.aws.networkmanager.model.GetCustomerGatewayAssociationsRequest.ReadOnly =
    new Wrapper(impl)
}
