package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateCoreNetworkResponse(
    coreNetwork: Optional[zio.aws.networkmanager.model.CoreNetwork] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkResponse = {
    import UpdateCoreNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkResponse
      .builder()
      .optionallyWith(coreNetwork.map(value => value.buildAwsValue()))(
        _.coreNetwork
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly =
    zio.aws.networkmanager.model.UpdateCoreNetworkResponse.wrap(buildAwsValue())
}
object UpdateCoreNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.UpdateCoreNetworkResponse =
      zio.aws.networkmanager.model
        .UpdateCoreNetworkResponse(coreNetwork.map(value => value.asEditable))
    def coreNetwork: Optional[zio.aws.networkmanager.model.CoreNetwork.ReadOnly]
    def getCoreNetwork: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetwork.ReadOnly
    ] = AwsError.unwrapOptionField("coreNetwork", coreNetwork)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkResponse
  ) extends zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly {
    override val coreNetwork
        : Optional[zio.aws.networkmanager.model.CoreNetwork.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetwork())
        .map(value => zio.aws.networkmanager.model.CoreNetwork.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.UpdateCoreNetworkResponse
  ): zio.aws.networkmanager.model.UpdateCoreNetworkResponse.ReadOnly =
    new Wrapper(impl)
}
