package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterTransitGatewayResponse(
    transitGatewayRegistration: Optional[
      zio.aws.networkmanager.model.TransitGatewayRegistration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse = {
    import DeregisterTransitGatewayResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse
      .builder()
      .optionallyWith(
        transitGatewayRegistration.map(value => value.buildAwsValue())
      )(_.transitGatewayRegistration)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly =
    zio.aws.networkmanager.model.DeregisterTransitGatewayResponse
      .wrap(buildAwsValue())
}
object DeregisterTransitGatewayResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DeregisterTransitGatewayResponse =
      zio.aws.networkmanager.model.DeregisterTransitGatewayResponse(
        transitGatewayRegistration.map(value => value.asEditable)
      )
    def transitGatewayRegistration: Optional[
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ]
    def getTransitGatewayRegistration: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "transitGatewayRegistration",
      transitGatewayRegistration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse
  ) extends zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly {
    override val transitGatewayRegistration: Optional[
      zio.aws.networkmanager.model.TransitGatewayRegistration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayRegistration())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayRegistration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeregisterTransitGatewayResponse
  ): zio.aws.networkmanager.model.DeregisterTransitGatewayResponse.ReadOnly =
    new Wrapper(impl)
}
