package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateTransitGatewayPeeringResponse(
    transitGatewayPeering: Optional[
      zio.aws.networkmanager.model.TransitGatewayPeering
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringResponse = {
    import CreateTransitGatewayPeeringResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringResponse
      .builder()
      .optionallyWith(
        transitGatewayPeering.map(value => value.buildAwsValue())
      )(_.transitGatewayPeering)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CreateTransitGatewayPeeringResponse.ReadOnly =
    zio.aws.networkmanager.model.CreateTransitGatewayPeeringResponse
      .wrap(buildAwsValue())
}
object CreateTransitGatewayPeeringResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.CreateTransitGatewayPeeringResponse =
      zio.aws.networkmanager.model.CreateTransitGatewayPeeringResponse(
        transitGatewayPeering.map(value => value.asEditable)
      )
    def transitGatewayPeering
        : Optional[zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly]
    def getTransitGatewayPeering: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly
    ] =
      AwsError.unwrapOptionField("transitGatewayPeering", transitGatewayPeering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringResponse
  ) extends zio.aws.networkmanager.model.CreateTransitGatewayPeeringResponse.ReadOnly {
    override val transitGatewayPeering: Optional[
      zio.aws.networkmanager.model.TransitGatewayPeering.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.transitGatewayPeering())
      .map(value =>
        zio.aws.networkmanager.model.TransitGatewayPeering.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CreateTransitGatewayPeeringResponse
  ): zio.aws.networkmanager.model.CreateTransitGatewayPeeringResponse.ReadOnly =
    new Wrapper(impl)
}
