package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  DateTime,
  AWSAccountId,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class NetworkResource(
    registeredGatewayArn: Optional[ResourceArn] = Optional.Absent,
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    awsRegion: Optional[ExternalRegionCode] = Optional.Absent,
    accountId: Optional[AWSAccountId] = Optional.Absent,
    resourceType: Optional[ConstrainedString] = Optional.Absent,
    resourceId: Optional[ConstrainedString] = Optional.Absent,
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    definition: Optional[ConstrainedString] = Optional.Absent,
    definitionTimestamp: Optional[DateTime] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] =
      Optional.Absent,
    metadata: Optional[Map[ConstrainedString, ConstrainedString]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkResource = {
    import NetworkResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkResource
      .builder()
      .optionallyWith(
        registeredGatewayArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.registeredGatewayArn)
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        awsRegion.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.awsRegion)
      .optionallyWith(
        accountId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        definition.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.definition)
      .optionallyWith(
        definitionTimestamp.map(value => DateTime.unwrap(value): Instant)
      )(_.definitionTimestamp)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        metadata.map(value =>
          value
            .map({ case (key, value) =>
              (ConstrainedString
                .unwrap(key): java.lang.String) -> (ConstrainedString
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkResource.ReadOnly =
    zio.aws.networkmanager.model.NetworkResource.wrap(buildAwsValue())
}
object NetworkResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkResource =
      zio.aws.networkmanager.model.NetworkResource(
        registeredGatewayArn.map(value => value),
        coreNetworkId.map(value => value),
        awsRegion.map(value => value),
        accountId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceArn.map(value => value),
        definition.map(value => value),
        definitionTimestamp.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        metadata.map(value => value)
      )
    def registeredGatewayArn: Optional[ResourceArn]
    def coreNetworkId: Optional[CoreNetworkId]
    def awsRegion: Optional[ExternalRegionCode]
    def accountId: Optional[AWSAccountId]
    def resourceType: Optional[ConstrainedString]
    def resourceId: Optional[ConstrainedString]
    def resourceArn: Optional[ResourceArn]
    def definition: Optional[ConstrainedString]
    def definitionTimestamp: Optional[DateTime]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def metadata: Optional[Map[ConstrainedString, ConstrainedString]]
    def getRegisteredGatewayArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("registeredGatewayArn", registeredGatewayArn)
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getAwsRegion: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getDefinition: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("definition", definition)
    def getDefinitionTimestamp: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("definitionTimestamp", definitionTimestamp)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getMetadata
        : ZIO[Any, AwsError, Map[ConstrainedString, ConstrainedString]] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResource
  ) extends zio.aws.networkmanager.model.NetworkResource.ReadOnly {
    override val registeredGatewayArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredGatewayArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ResourceArn(value)
        )
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val awsRegion: Optional[ExternalRegionCode] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val accountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val resourceType: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val resourceId: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val definition: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.definition())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val definitionTimestamp: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.definitionTimestamp())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
    override val metadata: Optional[Map[ConstrainedString, ConstrainedString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.networkmanager.model.primitives.ConstrainedString(
                key
              ) -> zio.aws.networkmanager.model.primitives
                .ConstrainedString(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkResource
  ): zio.aws.networkmanager.model.NetworkResource.ReadOnly = new Wrapper(impl)
}
