package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait SiteState {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.SiteState
}
object SiteState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.SiteState
  ): zio.aws.networkmanager.model.SiteState = value match {
    case software.amazon.awssdk.services.networkmanager.model.SiteState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.SiteState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkmanager.model.SiteState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.SiteState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkmanager.model.SiteState.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.SiteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.SiteState =
      software.amazon.awssdk.services.networkmanager.model.SiteState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.networkmanager.model.SiteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.SiteState =
      software.amazon.awssdk.services.networkmanager.model.SiteState.PENDING
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.SiteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.SiteState =
      software.amazon.awssdk.services.networkmanager.model.SiteState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.SiteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.SiteState =
      software.amazon.awssdk.services.networkmanager.model.SiteState.DELETING
  }
  case object UPDATING extends zio.aws.networkmanager.model.SiteState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.SiteState =
      software.amazon.awssdk.services.networkmanager.model.SiteState.UPDATING
  }
}
