package zio.aws.networkmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  DeviceArn,
  GlobalNetworkId,
  DeviceId,
  DateTime,
  SiteId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Device(
    deviceId: Optional[DeviceId] = Optional.Absent,
    deviceArn: Optional[DeviceArn] = Optional.Absent,
    globalNetworkId: Optional[GlobalNetworkId] = Optional.Absent,
    awsLocation: Optional[zio.aws.networkmanager.model.AWSLocation] =
      Optional.Absent,
    description: Optional[ConstrainedString] = Optional.Absent,
    `type`: Optional[ConstrainedString] = Optional.Absent,
    vendor: Optional[ConstrainedString] = Optional.Absent,
    model: Optional[ConstrainedString] = Optional.Absent,
    serialNumber: Optional[ConstrainedString] = Optional.Absent,
    location: Optional[zio.aws.networkmanager.model.Location] = Optional.Absent,
    siteId: Optional[SiteId] = Optional.Absent,
    createdAt: Optional[DateTime] = Optional.Absent,
    state: Optional[zio.aws.networkmanager.model.DeviceState] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.networkmanager.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Device
      .builder()
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        deviceArn.map(value => DeviceArn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        globalNetworkId.map(value =>
          GlobalNetworkId.unwrap(value): java.lang.String
        )
      )(_.globalNetworkId)
      .optionallyWith(awsLocation.map(value => value.buildAwsValue()))(
        _.awsLocation
      )
      .optionallyWith(
        description.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        `type`.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        vendor.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.vendor)
      .optionallyWith(
        model.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.model)
      .optionallyWith(
        serialNumber.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(createdAt.map(value => DateTime.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Device.ReadOnly =
    zio.aws.networkmanager.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Device
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Device =
      zio.aws.networkmanager.model.Device(
        deviceId.map(value => value),
        deviceArn.map(value => value),
        globalNetworkId.map(value => value),
        awsLocation.map(value => value.asEditable),
        description.map(value => value),
        `type`.map(value => value),
        vendor.map(value => value),
        model.map(value => value),
        serialNumber.map(value => value),
        location.map(value => value.asEditable),
        siteId.map(value => value),
        createdAt.map(value => value),
        state.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def deviceId: Optional[DeviceId]
    def deviceArn: Optional[DeviceArn]
    def globalNetworkId: Optional[GlobalNetworkId]
    def awsLocation: Optional[zio.aws.networkmanager.model.AWSLocation.ReadOnly]
    def description: Optional[ConstrainedString]
    def `type`: Optional[ConstrainedString]
    def vendor: Optional[ConstrainedString]
    def model: Optional[ConstrainedString]
    def serialNumber: Optional[ConstrainedString]
    def location: Optional[zio.aws.networkmanager.model.Location.ReadOnly]
    def siteId: Optional[SiteId]
    def createdAt: Optional[DateTime]
    def state: Optional[zio.aws.networkmanager.model.DeviceState]
    def tags: Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]]
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getDeviceArn: ZIO[Any, AwsError, DeviceArn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getGlobalNetworkId: ZIO[Any, AwsError, GlobalNetworkId] =
      AwsError.unwrapOptionField("globalNetworkId", globalNetworkId)
    def getAwsLocation: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.AWSLocation.ReadOnly
    ] = AwsError.unwrapOptionField("awsLocation", awsLocation)
    def getDescription: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("description", description)
    def getType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("type", `type`)
    def getVendor: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("vendor", vendor)
    def getModel: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("model", model)
    def getSerialNumber: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getLocation
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Location.ReadOnly] =
      AwsError.unwrapOptionField("location", location)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getCreatedAt: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getState: ZIO[Any, AwsError, zio.aws.networkmanager.model.DeviceState] =
      AwsError.unwrapOptionField("state", state)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Device
  ) extends zio.aws.networkmanager.model.Device.ReadOnly {
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val deviceArn: Optional[DeviceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceArn(value))
    override val globalNetworkId: Optional[GlobalNetworkId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.globalNetworkId())
        .map(value =>
          zio.aws.networkmanager.model.primitives.GlobalNetworkId(value)
        )
    override val awsLocation
        : Optional[zio.aws.networkmanager.model.AWSLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLocation())
        .map(value => zio.aws.networkmanager.model.AWSLocation.wrap(value))
    override val description: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val `type`: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val vendor: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val model: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val serialNumber: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serialNumber())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val location
        : Optional[zio.aws.networkmanager.model.Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.networkmanager.model.Location.wrap(value))
    override val siteId: Optional[SiteId] = zio.aws.core.internal
      .optionalFromNullable(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val createdAt: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.networkmanager.model.primitives.DateTime(value))
    override val state: Optional[zio.aws.networkmanager.model.DeviceState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.networkmanager.model.DeviceState.wrap(value))
    override val tags
        : Optional[List[zio.aws.networkmanager.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Device
  ): zio.aws.networkmanager.model.Device.ReadOnly = new Wrapper(impl)
}
