package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePeeringResponse(
    peering: Optional[zio.aws.networkmanager.model.Peering] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeletePeeringResponse = {
    import DeletePeeringResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeletePeeringResponse
      .builder()
      .optionallyWith(peering.map(value => value.buildAwsValue()))(_.peering)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.DeletePeeringResponse.ReadOnly =
    zio.aws.networkmanager.model.DeletePeeringResponse.wrap(buildAwsValue())
}
object DeletePeeringResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeletePeeringResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.DeletePeeringResponse =
      zio.aws.networkmanager.model
        .DeletePeeringResponse(peering.map(value => value.asEditable))
    def peering: Optional[zio.aws.networkmanager.model.Peering.ReadOnly]
    def getPeering
        : ZIO[Any, AwsError, zio.aws.networkmanager.model.Peering.ReadOnly] =
      AwsError.unwrapOptionField("peering", peering)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeletePeeringResponse
  ) extends zio.aws.networkmanager.model.DeletePeeringResponse.ReadOnly {
    override val peering
        : Optional[zio.aws.networkmanager.model.Peering.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.peering())
        .map(value => zio.aws.networkmanager.model.Peering.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeletePeeringResponse
  ): zio.aws.networkmanager.model.DeletePeeringResponse.ReadOnly = new Wrapper(
    impl
  )
}
