package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait ChangeStatus {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.ChangeStatus
}
object ChangeStatus {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ChangeStatus
  ): zio.aws.networkmanager.model.ChangeStatus = value match {
    case software.amazon.awssdk.services.networkmanager.model.ChangeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeStatus.NOT_STARTED =>
      val r = NOT_STARTED
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeStatus.COMPLETE =>
      val r = COMPLETE
      r
    case software.amazon.awssdk.services.networkmanager.model.ChangeStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeStatus =
      software.amazon.awssdk.services.networkmanager.model.ChangeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_STARTED extends zio.aws.networkmanager.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeStatus =
      software.amazon.awssdk.services.networkmanager.model.ChangeStatus.NOT_STARTED
  }
  case object IN_PROGRESS extends zio.aws.networkmanager.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeStatus =
      software.amazon.awssdk.services.networkmanager.model.ChangeStatus.IN_PROGRESS
  }
  case object COMPLETE extends zio.aws.networkmanager.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeStatus =
      software.amazon.awssdk.services.networkmanager.model.ChangeStatus.COMPLETE
  }
  case object FAILED extends zio.aws.networkmanager.model.ChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ChangeStatus =
      software.amazon.awssdk.services.networkmanager.model.ChangeStatus.FAILED
  }
}
