package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  GlobalNetworkId,
  DeviceId,
  SiteId,
  MaxResults
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetDevicesRequest(
    globalNetworkId: GlobalNetworkId,
    deviceIds: Optional[Iterable[DeviceId]] = Optional.Absent,
    siteId: Optional[SiteId] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest = {
    import GetDevicesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        deviceIds.map(value =>
          value.map { item =>
            DeviceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.deviceIds)
      .optionallyWith(
        siteId.map(value => SiteId.unwrap(value): java.lang.String)
      )(_.siteId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetDevicesRequest.ReadOnly =
    zio.aws.networkmanager.model.GetDevicesRequest.wrap(buildAwsValue())
}
object GetDevicesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetDevicesRequest =
      zio.aws.networkmanager.model.GetDevicesRequest(
        globalNetworkId,
        deviceIds.map(value => value),
        siteId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def deviceIds: Optional[List[DeviceId]]
    def siteId: Optional[SiteId]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getDeviceIds: ZIO[Any, AwsError, List[DeviceId]] =
      AwsError.unwrapOptionField("deviceIds", deviceIds)
    def getSiteId: ZIO[Any, AwsError, SiteId] =
      AwsError.unwrapOptionField("siteId", siteId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
  ) extends zio.aws.networkmanager.model.GetDevicesRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val deviceIds: Optional[List[DeviceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.networkmanager.model.primitives.DeviceId(item)
        }.toList
      )
    override val siteId: Optional[SiteId] = zio.aws.core.internal
      .optionalFromNullable(impl.siteId())
      .map(value => zio.aws.networkmanager.model.primitives.SiteId(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetDevicesRequest
  ): zio.aws.networkmanager.model.GetDevicesRequest.ReadOnly = new Wrapper(impl)
}
