package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteCoreNetworkPolicyVersionResponse(
    coreNetworkPolicy: Optional[
      zio.aws.networkmanager.model.CoreNetworkPolicy
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse = {
    import DeleteCoreNetworkPolicyVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse
      .builder()
      .optionallyWith(coreNetworkPolicy.map(value => value.buildAwsValue()))(
        _.coreNetworkPolicy
      )
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly =
    zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse
      .wrap(buildAwsValue())
}
object DeleteCoreNetworkPolicyVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse =
      zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse(
        coreNetworkPolicy.map(value => value.asEditable)
      )
    def coreNetworkPolicy
        : Optional[zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly]
    def getCoreNetworkPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("coreNetworkPolicy", coreNetworkPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse
  ) extends zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly {
    override val coreNetworkPolicy
        : Optional[zio.aws.networkmanager.model.CoreNetworkPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.coreNetworkPolicy())
        .map(value =>
          zio.aws.networkmanager.model.CoreNetworkPolicy.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse
  ): zio.aws.networkmanager.model.DeleteCoreNetworkPolicyVersionResponse.ReadOnly =
    new Wrapper(impl)
}
