package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait PeeringType {
  def unwrap: software.amazon.awssdk.services.networkmanager.model.PeeringType
}
object PeeringType {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.PeeringType
  ): zio.aws.networkmanager.model.PeeringType = value match {
    case software.amazon.awssdk.services.networkmanager.model.PeeringType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.PeeringType.TRANSIT_GATEWAY =>
      val r = TRANSIT_GATEWAY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.PeeringType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.PeeringType =
      software.amazon.awssdk.services.networkmanager.model.PeeringType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRANSIT_GATEWAY extends zio.aws.networkmanager.model.PeeringType {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.PeeringType =
      software.amazon.awssdk.services.networkmanager.model.PeeringType.TRANSIT_GATEWAY
  }
}
