package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  ConstrainedString,
  AWSAccountId,
  ExternalRegionCode,
  ResourceArn,
  CoreNetworkId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NetworkTelemetry(
    registeredGatewayArn: Optional[ResourceArn] = Optional.Absent,
    coreNetworkId: Optional[CoreNetworkId] = Optional.Absent,
    awsRegion: Optional[ExternalRegionCode] = Optional.Absent,
    accountId: Optional[AWSAccountId] = Optional.Absent,
    resourceType: Optional[ConstrainedString] = Optional.Absent,
    resourceId: Optional[ConstrainedString] = Optional.Absent,
    resourceArn: Optional[ResourceArn] = Optional.Absent,
    address: Optional[ConstrainedString] = Optional.Absent,
    health: Optional[zio.aws.networkmanager.model.ConnectionHealth] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry = {
    import NetworkTelemetry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
      .builder()
      .optionallyWith(
        registeredGatewayArn.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.registeredGatewayArn)
      .optionallyWith(
        coreNetworkId.map(value =>
          CoreNetworkId.unwrap(value): java.lang.String
        )
      )(_.coreNetworkId)
      .optionallyWith(
        awsRegion.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.awsRegion)
      .optionallyWith(
        accountId.map(value => AWSAccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        resourceType.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        resourceId.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        resourceArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        address.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.address)
      .optionallyWith(health.map(value => value.buildAwsValue()))(_.health)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly =
    zio.aws.networkmanager.model.NetworkTelemetry.wrap(buildAwsValue())
}
object NetworkTelemetry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.NetworkTelemetry =
      zio.aws.networkmanager.model.NetworkTelemetry(
        registeredGatewayArn.map(value => value),
        coreNetworkId.map(value => value),
        awsRegion.map(value => value),
        accountId.map(value => value),
        resourceType.map(value => value),
        resourceId.map(value => value),
        resourceArn.map(value => value),
        address.map(value => value),
        health.map(value => value.asEditable)
      )
    def registeredGatewayArn: Optional[ResourceArn]
    def coreNetworkId: Optional[CoreNetworkId]
    def awsRegion: Optional[ExternalRegionCode]
    def accountId: Optional[AWSAccountId]
    def resourceType: Optional[ConstrainedString]
    def resourceId: Optional[ConstrainedString]
    def resourceArn: Optional[ResourceArn]
    def address: Optional[ConstrainedString]
    def health: Optional[zio.aws.networkmanager.model.ConnectionHealth.ReadOnly]
    def getRegisteredGatewayArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("registeredGatewayArn", registeredGatewayArn)
    def getCoreNetworkId: ZIO[Any, AwsError, CoreNetworkId] =
      AwsError.unwrapOptionField("coreNetworkId", coreNetworkId)
    def getAwsRegion: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("awsRegion", awsRegion)
    def getAccountId: ZIO[Any, AwsError, AWSAccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getResourceType: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getResourceId: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getAddress: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("address", address)
    def getHealth: ZIO[
      Any,
      AwsError,
      zio.aws.networkmanager.model.ConnectionHealth.ReadOnly
    ] = AwsError.unwrapOptionField("health", health)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
  ) extends zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly {
    override val registeredGatewayArn: Optional[ResourceArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registeredGatewayArn())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ResourceArn(value)
        )
    override val coreNetworkId: Optional[CoreNetworkId] = zio.aws.core.internal
      .optionalFromNullable(impl.coreNetworkId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.CoreNetworkId(value)
      )
    override val awsRegion: Optional[ExternalRegionCode] = zio.aws.core.internal
      .optionalFromNullable(impl.awsRegion())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
      )
    override val accountId: Optional[AWSAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.networkmanager.model.primitives.AWSAccountId(value))
    override val resourceType: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val resourceId: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceId())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val resourceArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.networkmanager.model.primitives.ResourceArn(value))
    override val address: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.address())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
    override val health
        : Optional[zio.aws.networkmanager.model.ConnectionHealth.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.health())
        .map(value => zio.aws.networkmanager.model.ConnectionHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.NetworkTelemetry
  ): zio.aws.networkmanager.model.NetworkTelemetry.ReadOnly = new Wrapper(impl)
}
