package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Bandwidth(
    uploadSpeed: Optional[Integer] = Optional.Absent,
    downloadSpeed: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.Bandwidth = {
    import Bandwidth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.Bandwidth
      .builder()
      .optionallyWith(uploadSpeed.map(value => value: java.lang.Integer))(
        _.uploadSpeed
      )
      .optionallyWith(downloadSpeed.map(value => value: java.lang.Integer))(
        _.downloadSpeed
      )
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.Bandwidth.ReadOnly =
    zio.aws.networkmanager.model.Bandwidth.wrap(buildAwsValue())
}
object Bandwidth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.Bandwidth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.Bandwidth =
      zio.aws.networkmanager.model.Bandwidth(
        uploadSpeed.map(value => value),
        downloadSpeed.map(value => value)
      )
    def uploadSpeed: Optional[Integer]
    def downloadSpeed: Optional[Integer]
    def getUploadSpeed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("uploadSpeed", uploadSpeed)
    def getDownloadSpeed: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("downloadSpeed", downloadSpeed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.Bandwidth
  ) extends zio.aws.networkmanager.model.Bandwidth.ReadOnly {
    override val uploadSpeed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadSpeed())
      .map(value => value: Integer)
    override val downloadSpeed: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.downloadSpeed())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.Bandwidth
  ): zio.aws.networkmanager.model.Bandwidth.ReadOnly = new Wrapper(impl)
}
