package zio.aws.networkmanager.model
import scala.jdk.CollectionConverters._
sealed trait ConnectionState {
  def unwrap
      : software.amazon.awssdk.services.networkmanager.model.ConnectionState
}
object ConnectionState {
  def wrap(
      value: software.amazon.awssdk.services.networkmanager.model.ConnectionState
  ): zio.aws.networkmanager.model.ConnectionState = value match {
    case software.amazon.awssdk.services.networkmanager.model.ConnectionState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionState.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionState.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.networkmanager.model.ConnectionState.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkmanager.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionState =
      software.amazon.awssdk.services.networkmanager.model.ConnectionState.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.networkmanager.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionState =
      software.amazon.awssdk.services.networkmanager.model.ConnectionState.PENDING
  }
  case object AVAILABLE extends zio.aws.networkmanager.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionState =
      software.amazon.awssdk.services.networkmanager.model.ConnectionState.AVAILABLE
  }
  case object DELETING extends zio.aws.networkmanager.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionState =
      software.amazon.awssdk.services.networkmanager.model.ConnectionState.DELETING
  }
  case object UPDATING extends zio.aws.networkmanager.model.ConnectionState {
    override def unwrap
        : software.amazon.awssdk.services.networkmanager.model.ConnectionState =
      software.amazon.awssdk.services.networkmanager.model.ConnectionState.UPDATING
  }
}
