package zio.aws.networkmanager.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkmanager.model.primitives.{
  NextToken,
  GlobalNetworkId,
  DeviceId,
  ConnectionId,
  MaxResults
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetConnectionsRequest(
    globalNetworkId: GlobalNetworkId,
    connectionIds: Optional[Iterable[ConnectionId]] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest = {
    import GetConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
      .builder()
      .globalNetworkId(
        GlobalNetworkId.unwrap(globalNetworkId): java.lang.String
      )
      .optionallyWith(
        connectionIds.map(value =>
          value.map { item =>
            ConnectionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.connectionIds)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.networkmanager.model.GetConnectionsRequest.ReadOnly =
    zio.aws.networkmanager.model.GetConnectionsRequest.wrap(buildAwsValue())
}
object GetConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.GetConnectionsRequest =
      zio.aws.networkmanager.model.GetConnectionsRequest(
        globalNetworkId,
        connectionIds.map(value => value),
        deviceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def globalNetworkId: GlobalNetworkId
    def connectionIds: Optional[List[ConnectionId]]
    def deviceId: Optional[DeviceId]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getGlobalNetworkId: ZIO[Any, Nothing, GlobalNetworkId] =
      ZIO.succeed(globalNetworkId)
    def getConnectionIds: ZIO[Any, AwsError, List[ConnectionId]] =
      AwsError.unwrapOptionField("connectionIds", connectionIds)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
  ) extends zio.aws.networkmanager.model.GetConnectionsRequest.ReadOnly {
    override val globalNetworkId: GlobalNetworkId =
      zio.aws.networkmanager.model.primitives
        .GlobalNetworkId(impl.globalNetworkId())
    override val connectionIds: Optional[List[ConnectionId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.networkmanager.model.primitives.ConnectionId(item)
          }.toList
        )
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.networkmanager.model.primitives.DeviceId(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.networkmanager.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.networkmanager.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.GetConnectionsRequest
  ): zio.aws.networkmanager.model.GetConnectionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
