package zio.aws.networkmanager.model
import zio.ZIO
import zio.aws.networkmanager.model.primitives.{
  AttachmentId,
  ConstrainedString,
  ExternalRegionCode
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CoreNetworkChangeEventValues(
    edgeLocation: Optional[ExternalRegionCode] = Optional.Absent,
    segmentName: Optional[ConstrainedString] = Optional.Absent,
    attachmentId: Optional[AttachmentId] = Optional.Absent,
    cidr: Optional[ConstrainedString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEventValues = {
    import CoreNetworkChangeEventValues.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEventValues
      .builder()
      .optionallyWith(
        edgeLocation.map(value =>
          ExternalRegionCode.unwrap(value): java.lang.String
        )
      )(_.edgeLocation)
      .optionallyWith(
        segmentName.map(value =>
          ConstrainedString.unwrap(value): java.lang.String
        )
      )(_.segmentName)
      .optionallyWith(
        attachmentId.map(value => AttachmentId.unwrap(value): java.lang.String)
      )(_.attachmentId)
      .optionallyWith(
        cidr.map(value => ConstrainedString.unwrap(value): java.lang.String)
      )(_.cidr)
      .build()
  }
  def asReadOnly
      : zio.aws.networkmanager.model.CoreNetworkChangeEventValues.ReadOnly =
    zio.aws.networkmanager.model.CoreNetworkChangeEventValues
      .wrap(buildAwsValue())
}
object CoreNetworkChangeEventValues {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEventValues
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkmanager.model.CoreNetworkChangeEventValues =
      zio.aws.networkmanager.model.CoreNetworkChangeEventValues(
        edgeLocation.map(value => value),
        segmentName.map(value => value),
        attachmentId.map(value => value),
        cidr.map(value => value)
      )
    def edgeLocation: Optional[ExternalRegionCode]
    def segmentName: Optional[ConstrainedString]
    def attachmentId: Optional[AttachmentId]
    def cidr: Optional[ConstrainedString]
    def getEdgeLocation: ZIO[Any, AwsError, ExternalRegionCode] =
      AwsError.unwrapOptionField("edgeLocation", edgeLocation)
    def getSegmentName: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("segmentName", segmentName)
    def getAttachmentId: ZIO[Any, AwsError, AttachmentId] =
      AwsError.unwrapOptionField("attachmentId", attachmentId)
    def getCidr: ZIO[Any, AwsError, ConstrainedString] =
      AwsError.unwrapOptionField("cidr", cidr)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEventValues
  ) extends zio.aws.networkmanager.model.CoreNetworkChangeEventValues.ReadOnly {
    override val edgeLocation: Optional[ExternalRegionCode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.edgeLocation())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ExternalRegionCode(value)
        )
    override val segmentName: Optional[ConstrainedString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.segmentName())
        .map(value =>
          zio.aws.networkmanager.model.primitives.ConstrainedString(value)
        )
    override val attachmentId: Optional[AttachmentId] = zio.aws.core.internal
      .optionalFromNullable(impl.attachmentId())
      .map(value => zio.aws.networkmanager.model.primitives.AttachmentId(value))
    override val cidr: Optional[ConstrainedString] = zio.aws.core.internal
      .optionalFromNullable(impl.cidr())
      .map(value =>
        zio.aws.networkmanager.model.primitives.ConstrainedString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkmanager.model.CoreNetworkChangeEventValues
  ): zio.aws.networkmanager.model.CoreNetworkChangeEventValues.ReadOnly =
    new Wrapper(impl)
}
